// Generated by CoffeeScript 1.10.0
(function() {
  var CoreScroller, Scroller, activatedElement, checkVisibility, doesScroll, findScrollableElement, firstScrollableElement, getDimension, getSign, performScroll, root, scrollProperties, shouldScroll;

  activatedElement = null;

  getSign = function(val) {
    if (!val) {
      return 0;
    } else {
      if (val < 0) {
        return -1;
      } else {
        return 1;
      }
    }
  };

  scrollProperties = {
    x: {
      axisName: 'scrollLeft',
      max: 'scrollWidth',
      viewSize: 'clientWidth'
    },
    y: {
      axisName: 'scrollTop',
      max: 'scrollHeight',
      viewSize: 'clientHeight'
    }
  };

  getDimension = function(el, direction, amount) {
    var name;
    if (Utils.isString(amount)) {
      name = amount;
      if (name === 'viewSize' && el === document.body) {
        if (direction === 'x') {
          return window.innerWidth;
        } else {
          return window.innerHeight;
        }
      } else {
        return el[scrollProperties[direction][name]];
      }
    } else {
      return amount;
    }
  };

  performScroll = function(element, direction, amount) {
    var axisName, before;
    axisName = scrollProperties[direction].axisName;
    before = element[axisName];
    element[axisName] += amount;
    return element[axisName] !== before;
  };

  shouldScroll = function(element, direction) {
    var computedStyle, ref;
    computedStyle = window.getComputedStyle(element);
    if (computedStyle.getPropertyValue("overflow-" + direction) === "hidden") {
      return false;
    }
    if ((ref = computedStyle.getPropertyValue("visibility")) === "hidden" || ref === "collapse") {
      return false;
    }
    if (computedStyle.getPropertyValue("display") === "none") {
      return false;
    }
    return true;
  };

  doesScroll = function(element, direction, amount, factor) {
    var delta;
    delta = factor * getDimension(element, direction, amount) || -1;
    delta = getSign(delta);
    return performScroll(element, direction, delta) && performScroll(element, direction, -delta);
  };

  findScrollableElement = function(element, direction, amount, factor) {
    var ref;
    while (element !== document.body && !(doesScroll(element, direction, amount, factor) && shouldScroll(element, direction))) {
      element = (ref = DomUtils.getContainingElement(element)) != null ? ref : document.body;
    }
    return element;
  };

  firstScrollableElement = function(element) {
    var child, children, ele, i, len, ref;
    if (element == null) {
      element = document.body;
    }
    if (doesScroll(element, "y", 1, 1) || doesScroll(element, "y", -1, 1)) {
      return element;
    } else {
      children = (function() {
        var i, len, ref, results;
        ref = element.children;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          child = ref[i];
          results.push({
            element: child,
            rect: DomUtils.getVisibleClientRect(child)
          });
        }
        return results;
      })();
      children = children.filter(function(child) {
        return child.rect;
      });
      children.map(function(child) {
        return child.area = child.rect.width * child.rect.height;
      });
      ref = children.sort(function(a, b) {
        return b.area - a.area;
      });
      for (i = 0, len = ref.length; i < len; i++) {
        child = ref[i];
        if (ele = firstScrollableElement(child.element)) {
          return ele;
        }
      }
      return null;
    }
  };

  checkVisibility = function(element) {
    var rect;
    rect = activatedElement.getBoundingClientRect();
    if (rect.bottom < 0 || rect.top > window.innerHeight || rect.right < 0 || rect.left > window.innerWidth) {
      return activatedElement = element;
    }
  };

  CoreScroller = {
    init: function() {
      this.time = 0;
      this.lastEvent = null;
      this.keyIsDown = false;
      return handlerStack.push({
        _name: 'scroller/track-key-status',
        keydown: (function(_this) {
          return function(event) {
            return handlerStack.alwaysContinueBubbling(function() {
              _this.keyIsDown = true;
              if (!event.repeat) {
                _this.time += 1;
              }
              return _this.lastEvent = event;
            });
          };
        })(this),
        keyup: (function(_this) {
          return function() {
            return handlerStack.alwaysContinueBubbling(function() {
              _this.keyIsDown = false;
              return _this.time += 1;
            });
          };
        })(this),
        blur: (function(_this) {
          return function() {
            return handlerStack.alwaysContinueBubbling(function() {
              if (event.target === window) {
                return _this.time += 1;
              }
            });
          };
        })(this)
      });
    },
    wouldNotInitiateScroll: function() {
      var ref;
      return ((ref = this.lastEvent) != null ? ref.repeat : void 0) && Settings.get("smoothScroll");
    },
    minCalibration: 0.5,
    maxCalibration: 1.6,
    calibrationBoundary: 150,
    scroll: function(element, direction, amount, continuous) {
      var activationTime, animate, calibration, duration, myKeyIsStillDown, previousTimestamp, ref, sign, totalDelta, totalElapsed;
      if (continuous == null) {
        continuous = true;
      }
      if (!amount) {
        return;
      }
      if (!Settings.get("smoothScroll")) {
        performScroll(element, direction, amount);
        checkVisibility(element);
        return;
      }
      if ((ref = this.lastEvent) != null ? ref.repeat : void 0) {
        return;
      }
      activationTime = ++this.time;
      myKeyIsStillDown = (function(_this) {
        return function() {
          return _this.time === activationTime && _this.keyIsDown;
        };
      })(this);
      sign = getSign(amount);
      amount = Math.abs(amount);
      duration = Math.max(100, 20 * Math.log(amount));
      totalDelta = 0;
      totalElapsed = 0.0;
      calibration = 1.0;
      previousTimestamp = null;
      animate = (function(_this) {
        return function(timestamp) {
          var delta, elapsed;
          if (previousTimestamp == null) {
            previousTimestamp = timestamp;
          }
          if (timestamp === previousTimestamp) {
            return requestAnimationFrame(animate);
          }
          elapsed = timestamp - previousTimestamp;
          totalElapsed += elapsed;
          previousTimestamp = timestamp;
          if (myKeyIsStillDown() && 75 <= totalElapsed && (_this.minCalibration <= calibration && calibration <= _this.maxCalibration)) {
            if (1.05 * calibration * amount < _this.calibrationBoundary) {
              calibration *= 1.05;
            }
            if (_this.calibrationBoundary < 0.95 * calibration * amount) {
              calibration *= 0.95;
            }
          }
          delta = Math.ceil(amount * (elapsed / duration) * calibration);
          delta = myKeyIsStillDown() ? delta : Math.max(0, Math.min(delta, amount - totalDelta));
          if (delta && performScroll(element, direction, sign * delta)) {
            totalDelta += delta;
            return requestAnimationFrame(animate);
          } else {
            return checkVisibility(element);
          }
        };
      })(this);
      if (!continuous) {
        ++this.time;
      }
      return requestAnimationFrame(animate);
    }
  };

  Scroller = {
    init: function() {
      handlerStack.push({
        _name: 'scroller/active-element',
        DOMActivate: function(event) {
          return handlerStack.alwaysContinueBubbling(function() {
            var ref, ref1, ref2, ref3;
            return activatedElement = (ref = (ref1 = (ref2 = event.deepPath) != null ? ref2[0] : void 0) != null ? ref1 : (ref3 = event.path) != null ? ref3[0] : void 0) != null ? ref : event.target;
          });
        }
      });
      return CoreScroller.init();
    },
    scrollBy: function(direction, amount, factor) {
      var element, elementAmount;
      if (factor == null) {
        factor = 1;
      }
      if (!document.body && amount instanceof Number) {
        if (direction === "x") {
          window.scrollBy(amount, 0);
        } else {
          window.scrollBy(0, amount);
        }
        return;
      }
      activatedElement || (activatedElement = (document.body && firstScrollableElement()) || document.body);
      if (!activatedElement) {
        return;
      }
      if (!CoreScroller.wouldNotInitiateScroll()) {
        element = findScrollableElement(activatedElement, direction, amount, factor);
        elementAmount = factor * getDimension(element, direction, amount);
        return CoreScroller.scroll(element, direction, elementAmount);
      }
    },
    scrollTo: function(direction, pos) {
      var amount, element;
      activatedElement || (activatedElement = (document.body && firstScrollableElement()) || document.body);
      if (!activatedElement) {
        return;
      }
      element = findScrollableElement(activatedElement, direction, pos, 1);
      amount = getDimension(element, direction, pos) - element[scrollProperties[direction].axisName];
      return CoreScroller.scroll(element, direction, amount);
    },
    scrollIntoView: function(element) {
      var amount, rect, ref;
      activatedElement || (activatedElement = document.body && firstScrollableElement());
      rect = (ref = element.getClientRects()) != null ? ref[0] : void 0;
      if (rect != null) {
        if (rect.bottom < 0) {
          amount = rect.bottom - Math.min(rect.height, window.innerHeight);
          element = findScrollableElement(element, "y", amount, 1);
          CoreScroller.scroll(element, "y", amount, false);
        } else if (window.innerHeight < rect.top) {
          amount = rect.top + Math.min(rect.height - window.innerHeight, 0);
          element = findScrollableElement(element, "y", amount, 1);
          CoreScroller.scroll(element, "y", amount, false);
        }
        if (rect.right < 0) {
          amount = rect.right - Math.min(rect.width, window.innerWidth);
          element = findScrollableElement(element, "x", amount, 1);
          return CoreScroller.scroll(element, "x", amount, false);
        } else if (window.innerWidth < rect.left) {
          amount = rect.left + Math.min(rect.width - window.innerWidth, 0);
          element = findScrollableElement(element, "x", amount, 1);
          return CoreScroller.scroll(element, "x", amount, false);
        }
      }
    },
    scrollToPosition: function(element, top, left) {
      var amount;
      activatedElement || (activatedElement = document.body && firstScrollableElement());
      amount = top + 20 - (element.clientHeight + element.scrollTop);
      if (0 < amount) {
        CoreScroller.scroll(element, "y", amount, false);
      }
      amount = top - element.scrollTop - 5;
      if (amount < 0) {
        CoreScroller.scroll(element, "y", amount, false);
      }
      amount = left + 20 - (element.clientWidth + element.scrollLeft);
      if (0 < amount) {
        CoreScroller.scroll(element, "x", amount, false);
      }
      amount = left - element.scrollLeft - 5;
      if (amount < 0) {
        return CoreScroller.scroll(element, "x", amount, false);
      }
    }
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Scroller = Scroller;

}).call(this);
